package com.agilex.healthcare.directscheduling.validator;

import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;


@Provider
public class MdwsResponsesExceptionMapper implements ExceptionMapper<MdwsResponseException>{
	
	@Override
	public Response toResponse(MdwsResponseException ex) {
		return Response.status(Response.Status.BAD_REQUEST).entity("Error: "+ex.getDetailMessage()).type(MediaType.APPLICATION_JSON).build();
	}
}